Imports System.IO
Imports MySql.Data
Imports MySql.Data.MySqlClient
Imports System.Data

Partial Class Select_MySQL
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        ' When the page loads we get data from session variables to us in our Select statements
        If Page.IsPostBack = False Then
            HiddenCompanyID.Value = Convert.ToString(Session("CompanyID"))
        End If

    End Sub

    Protected Sub btnGetData_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnGetData.Click

        ' We declare two variables that will be used to "SELECT" data from a table in a database.
        Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
        Dim sql As String = "SELECT Place, AssetOwnID, AssetName, VerNumber, Supplier FROM Assets WHERE CompanyID = @CompanyID AND SoldScraped = '0' ORDER BY Place"

        ' We declare cn as a new instance of the MySQLConnection class and supplies "ConnString" as a parameter.
        ' MySqlConnection has a dispose and a close method, they are doing the same thing so we only need to call
        ' one of them when we are finished with the object. We are going to call close in the "Finally" block
        ' to be sure that the close method will be called even if there is an exception.
        Dim cn As New MySqlConnection(ConnString)

        ' We declare cmd as a new instance of the MySqlCommand class and suppliy "sql" and "cn" as a parameters.
        ' MySqlCommand has a dispose method. We are going to call dispose in the "Finally" block
        ' to be sure that the dispose method will be called even if there is an exception.
        Dim cmd As New MySqlCommand(sql, cn)

        ' We declare reader as a MySqlDataReader object. MySqlDataReader has a close method and we are going 
        ' to call close in the "Finally" block to be sure that the close method will be called even if there 
        ' is an exception.
        Dim reader As MySqlDataReader = Nothing

        ' We include structured error handling by creating a "Try" block, by putting the application code
        ' inside the "Try" block and by including two "Catch" blocks.
        Try

            ' We add a parameter to be used in the "SELECT" statement
            cmd.Parameters.Add("@CompanyID", MySqlDbType.Int64).Value = HiddenCompanyID.Value

            ' We open the connection to the database.
            cn.Open()

            ' We put the data from the "SELECT" statement in the reader variable. 
            reader = cmd.ExecuteReader()

            ' This code binds the data in the reader variable to the repeater control in the web form.
            SelectToRepeaterDataReader.DataSource = reader
            SelectToRepeaterDataReader.DataBind()

        Catch sqlEx As MySqlException

            ' Catch a specific exception, a MySqlException
            Response.Write(sqlEx.Message)

        Catch ex As Exception

            ' Catch a general exception to include all the exceptions that dont are MySqlExceptions.
            Response.Write(ex.Message)

        Finally

            ' Dispose of objects even if there will be an exception in the "Try" block. The dispose methods are
            ' designed so that you can call them how many times you want even if there isnt a object to dispose.

            ' Close the MySqlConnection object
            cn.Close()

            ' Dispose of the MySqlCommand object
            cmd.Dispose()

            ' Close the MySqlDataReader object
            If Not reader Is Nothing Then
                reader.Close()
            End If


        End Try

        ' //////////////////////////////////////////////////////////////////////////////////////////////////////
        ' AN ALTERNATIVE WAY TO CODE A TRY/CATCH/FINALLY BLOCK WITH THE "USING" STATEMENT
        ' //////////////////////////////////////////////////////////////////////////////////////////////////////
        'Try
        '    Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
        '    Dim sql As String = "SELECT Place, AssetOwnID, AssetName, VerNumber, Supplier FROM Assets WHERE CompanyID = @CompanyID AND SoldScraped = '0' ORDER BY Place"

        '    ' The Using block is used to call dispose (close) automatically even if there are an exception.
        '    Using cn As New MySqlConnection(ConnString), _
        '          cmd As New MySqlCommand(sql, cn)
        '        cmd.Parameters.Add("@CompanyID", MySqlDbType.Int64).Value = HiddenCompanyID.Value

        '        cn.Open()

        '        ' The Using block is used to call dispose (close) automatically even if there are an exception.
        '        Using reader As MySqlDataReader = cmd.ExecuteReader()
        '            SelectToRepeaterDataReader.DataSource = reader
        '            SelectToRepeaterDataReader.DataBind()
        '        End Using

        '    End Using

        'Catch sqlEx As MySqlException

        '    ' Throw a specific exception, a MySqlException
        '    Throw New Exception("MySpecificException", sqlEx)

        'Catch ex As Exception

        '    ' Throw a general exception to include all the exceptions that dont are MySqlExceptions.
        '    Throw New Exception("MyGeneralException", ex)

        'End Try

    End Sub
End Class
